//
//  Trust.h
//  Keychain
//
//  Created by Wade Tregaskis on Wed Feb 05 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "Certificate.h"
#import "Policy.h"
#import "Keychain.h"


@interface Trust : NSCachedObject {
    SecTrustRef trust;
    SecTrustResultType lastEval;
    int error;
}

+ (SecTrustUserSetting)userTrustForCeritifcate:(Certificate*)cert policy:(Policy*)pol;
+ (void)setUserTrustForCertificate:(Certificate*)cert policy:(Policy*)pol trust:(SecTrustUserSetting)tru;

+ (Trust*)trustForCertificates:(NSArray*)certificates policies:(NSArray*)policies;
+ (Trust*)trustWithTrustRef:(SecTrustRef)tru;

- (Trust*)initForCertificates:(NSArray*)certificates policies:(NSArray*)policies;
- (Trust*)initWithTrustRef:(SecTrustRef)tru;

- (void)makeTrustForKeychains:(NSArray*)chains;

- (void)allowExpiredCertificates:(BOOL)allow;

- (BOOL)canEvaluate;

- (BOOL)isInvalid;
- (BOOL)canProceed;
- (BOOL)needsConfirmation;
- (BOOL)userDenied;
- (BOOL)userDidNotSpecify;
- (BOOL)hasRecoverableFailure;
- (BOOL)hasFatalFailure;
- (BOOL)hasUnknownError;

- (int)lastError;
- (SecTrustRef)trustRef;

@end
